/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xusb.h
 * -----------------------------------------------------------------*/

#ifndef XUSB_H_INCLUDED
#define XUSB_H_INCLUDED

#include <xtypedef.h>
#include <xio.h>

 
/* --------------------------------------------------------------------------
 * Standard I/O functions (see iocommon.c)
 * -------------------------------------------------------------------------- */

  bx_errtype EXPORT BestXUSBDeviceConnect(bx_portnumtype OsHandle);
  bx_errtype EXPORT BestXUSBFXDeviceConnect(bx_portnumtype OsHandle);
 
  bx_errtype EXPORT BestXUSBCheckConnection(bx_portnumtype OsHandle);
  bx_errtype EXPORT BestXUSBFXCheckConnection(bx_portnumtype OsHandle);

  bx_errtype BestXUSBIsDisconnected(bx_portnumtype OsHandle);
  bx_errtype BestXUSBFXIsDisconnected(bx_portnumtype OsHandle);

  void EXPORT BestXUSBReleaseConnection(bx_portnumtype OsHandle);
  void EXPORT BestXUSBFXReleaseConnection(bx_portnumtype OsHandle);

  bx_errtype BestXUSBPortTimeoutSet(bx_portnumtype OsHandle, BESTTIMEOUTS * pCallersTimeouts);
  /* Default timeouts are defined in bx_io.h */

/* --------------------------------------------------------------------------
 * Other exposed functions
 * -------------------------------------------------------------------------- */

  bx_errtype EXPORT BestXOpenUSB(bx_int32 dwCardId, 
  bx_portnumtype * pOsHandle,
  bx_charptrtype filename);

  bx_errtype EXPORT BestXCloseUSB(bx_portnumtype OsHandle);

  /* 29er cards start at this offset, 30er at zero */
  #define BX_USB_PORTNUM_OFFSET 128

#ifndef LINUX
  /* Access to E2923 */
  bx_int32 BestXDRR23(bx_portnumtype OsHandle, unsigned long address, unsigned long size, unsigned long *val);
  bx_int32 BestXDRW23(bx_portnumtype OsHandle, unsigned long address, unsigned long size, unsigned long val);
#endif

#endif /* _BX_USB_H */
